import pandas as pd
import numpy as np
import pickle
from decision_company import read_csv_file, create_dataframe, concatenate_objects, extract_unique_values, update_dict


atp_tennis = read_csv_file('atp_tennis.csv')

# Retrieve unique surface types
surface_types = extract_unique_values(atp_tennis['Surface'])

# Initialize an empty dataframe for storing the results
columns = ['Player', 'Opponent', 'Win Rate', 'Head-to-Head'] + [f'{surface} Surface Performance' for surface in surface_types]
player_stats = create_dataframe(data=[], columns=columns)

# Loop through Federer's opponents
for opponent in federer_opponents:
    # Calculate win rate, head-to-head record, and surface performance for Raonic M. against each opponent
    win_rate, h2h_record, surface_performance = calculate_performance('Raonic M.', opponent, atp_tennis, surface_types)

    # Append the results to the dataframe
    row_data = {'Player': 'Raonic M.', 'Opponent': opponent, 'Win Rate': win_rate, 'Head-to-Head': h2h_record}
    update_dict(row_data, {f'{surface} Surface Performance': surface_performance[surface] for surface in surface_types})
    player_stats = concatenate_objects(player_stats, create_dataframe(row_data, index=[0]))  

# Display the resulting dataframe   
print(player_stats)
pickle.dump(player_stats,open("./ref_result/player_stats.pkl","wb"))